/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.convenientcurioscontainer.common;

import com.leobeliik.convenientcurioscontainer.Config;
import com.leobeliik.convenientcurioscontainer.ConvenientCuriosContainer;
import com.leobeliik.convenientcurioscontainer.common.slots.ConvenientCosmeticSlots;
import com.leobeliik.convenientcurioscontainer.common.slots.ConvenientCurioSlots;
import com.leobeliik.convenientcurioscontainer.items.ConvenientItem;
import com.leobeliik.convenientcurioscontainer.networking.Network;
import com.leobeliik.convenientcurioscontainer.networking.ScrollMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;

public class ConvenientContainer
extends AbstractContainerMenu {
    private final ItemStackHandler ccItemHandler;
    private final Player player;
    private final List<ConvenientCurioSlots> curioSlots = new ArrayList<ConvenientCurioSlots>();
    private final List<ConvenientCosmeticSlots> cosmeticSlots = new ArrayList<ConvenientCosmeticSlots>();
    private List<Boolean> hasCosmetic = new ArrayList<Boolean>();
    private boolean cosmeticColumn;

    public ConvenientContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, new ItemStackHandler(36));
    }

    public ConvenientContainer(int id, Inventory inventory, ItemStackHandler ccItemHandler) {
        super((MenuType)ConvenientCuriosContainer.CURIOS_CONTAINER_CONTAINER.get(), id);
        this.ccItemHandler = ccItemHandler;
        this.player = inventory.f_35978_;
        this.addContainerSlots(inventory);
        this.addPlayerInvSlots(inventory);
        this.addCuriosSlots();
    }

    private void addContainerSlots(Inventory inventory) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.ccItemHandler, j + i * 9, j * 18 + 8, i * 18 + 18){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return ConvenientContainer.this.isItemValid(stack);
                    }
                });
            }
        }
    }

    private void addPlayerInvSlots(Inventory inventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, j * 18 + 8, i * 18 + 104));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (inventory.m_8020_(i).m_41720_() instanceof ConvenientItem) {
                this.m_38897_(new Slot((Container)inventory, i, i * 18 + 8, 162){

                    @ParametersAreNonnullByDefault
                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, i, i * 18 + 8, 162));
        }
    }

    private void addCuriosSlots() {
        this.curioSlots.clear();
        this.cosmeticSlots.clear();
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.player).ifPresent(curios -> {
            int slotY = 13;
            for (Map.Entry entry : curios.getCurios().entrySet()) {
                String name = (String)entry.getKey();
                ICurioStacksHandler curioStack = (ICurioStacksHandler)entry.getValue();
                for (int i = 0; i < curioStack.getStacks().getSlots(); ++i) {
                    this.curioSlots.add(new ConvenientCurioSlots(this.player, curioStack.getStacks(), i, name, -18, slotY, (NonNullList<Boolean>)curioStack.getRenders()));
                    if (curioStack.hasCosmetic()) {
                        this.cosmeticSlots.add(new ConvenientCosmeticSlots(this.player, curioStack.getCosmeticStacks(), i, name, -37, slotY));
                        this.cosmeticColumn = true;
                    }
                    slotY += 18;
                }
            }
        });
        this.addCustomSlots();
    }

    private boolean isItemValid(ItemStack stack) {
        return !CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty() && stack.m_41720_().getRegistryName() != null && !Config.getForbiddenTrinkets().contains(stack.m_41720_().getRegistryName().toString());
    }

    private void addCustomSlots() {
        this.cosmeticSlots.stream().filter(cosmeticSlot -> cosmeticSlot.getY() >= 13 && cosmeticSlot.getY() <= 157).forEach(x$0 -> this.m_38897_((Slot)x$0));
        this.curioSlots.stream().filter(curioSlot -> curioSlot.getY() >= 13 && curioSlot.getY() <= 157).forEach(x$0 -> this.m_38897_((Slot)x$0));
    }

    public void scroll(int direction) {
        this.f_38839_.removeIf(s -> s instanceof CurioSlot);
        List<ConvenientCosmeticSlots> tempCosmetic = this.cosmeticSlots.stream().map(s -> new ConvenientCosmeticSlots(this.player, s.getHandler(), s.getIndex(), s.getIdentifier(), s.getX(), s.getY() + 18 * direction)).toList();
        this.cosmeticSlots.clear();
        this.cosmeticSlots.addAll(tempCosmetic);
        List<ConvenientCurioSlots> tempCurios = this.curioSlots.stream().map(s -> new ConvenientCurioSlots(this.player, s.getHandler(), s.getIndex(), s.getIdentifier(), s.getX(), s.getY() + 18 * direction, s.getRenders())).toList();
        this.curioSlots.clear();
        this.curioSlots.addAll(tempCurios);
        this.addCustomSlots();
        this.m_38946_();
        if (this.player.m_7578_()) {
            Network.sendToServer(new ScrollMessage(direction));
        }
    }

    public boolean canScroll(int direction) {
        int firstSlotY = this.curioSlots.get(0).getY();
        int lastSlotY = this.curioSlots.get(this.curioSlots.size() - 1).getY();
        return !(direction == 1 && firstSlotY == 13 || direction == -1 && lastSlotY <= 157);
    }

    public int curiosSize() {
        return this.curioSlots.size();
    }

    public List<Slot> getSlots() {
        return this.f_38839_;
    }

    public boolean hasCosmeticColumn() {
        return this.cosmeticColumn;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6875_(Player player) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStackOG = slot.m_7993_();
            itemStackCopy = itemStackOG.m_41777_();
            int size = 36;
            if (index < size ? !this.m_38903_(itemStackOG, size, this.f_38839_.size(), true) : !this.m_38903_(itemStackOG, 0, size, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStackOG.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStackCopy;
    }

    @ParametersAreNonnullByDefault
    public void m_150399_(int slot, int mouseClick, ClickType type, Player player) {
        if (mouseClick == 1 && slot >= 0 && slot < 36 && ((Slot)this.f_38839_.get(slot)).m_6657_()) {
            if (type == ClickType.PICKUP) {
                this.swapCurios((Slot)this.f_38839_.get(slot), player, false);
                return;
            }
            if (type == ClickType.QUICK_MOVE) {
                this.swapCurios((Slot)this.f_38839_.get(slot), player, true);
                return;
            }
        }
        super.m_150399_(slot, mouseClick, type, player);
    }

    private void swapCurios(Slot slot, Player player, boolean secondSlot) {
        ItemStack itemstack1 = null;
        ItemStack itemstack2 = slot.m_7993_();
        Slot curioSlot = null;
        for (Slot slot2 : this.curioSlots) {
            if (!slot2.m_5857_(itemstack2)) continue;
            if (secondSlot) {
                secondSlot = false;
                continue;
            }
            itemstack1 = slot2.m_7993_();
            curioSlot = slot2;
            break;
        }
        if (itemstack1 == null || !curioSlot.m_8010_(player)) {
            return;
        }
        if (!itemstack1.m_41619_() || !itemstack2.m_41619_()) {
            if (itemstack1.m_41619_()) {
                if (slot.m_8010_(player)) {
                    curioSlot.m_5852_(itemstack2);
                    slot.m_5852_(ItemStack.f_41583_);
                    slot.m_142406_(player, itemstack2);
                }
            } else if (itemstack2.m_41619_()) {
                if (slot.m_5857_(itemstack1)) {
                    int i = slot.m_5866_(itemstack1);
                    if (itemstack1.m_41613_() > i) {
                        slot.m_5852_(itemstack1.m_41620_(i));
                    } else {
                        slot.m_5852_(itemstack1);
                        curioSlot.m_5852_(ItemStack.f_41583_);
                    }
                }
            } else if (slot.m_8010_(player) && slot.m_5857_(itemstack1)) {
                int l1 = slot.m_5866_(itemstack1);
                if (itemstack1.m_41613_() > l1) {
                    slot.m_5852_(itemstack1.m_41620_(l1));
                    slot.m_142406_(player, itemstack2);
                    if (!curioSlot.m_5857_(itemstack2)) {
                        player.m_36176_(itemstack2, true);
                    }
                } else {
                    slot.m_5852_(itemstack1);
                    curioSlot.m_5852_(itemstack2);
                    slot.m_142406_(player, itemstack2);
                }
            }
        }
    }
}

